<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../helpers.php';
requireAdmin();
// counts
$totUsers = $pdo->query("SELECT COUNT(*) AS c FROM users")->fetch()['c'];
$totLogs = $pdo->query("SELECT COUNT(*) AS c FROM activity_logs")->fetch()['c'];
$recent = $pdo->query("SELECT al.*, u.name FROM activity_logs al JOIN users u ON u.id=al.user_id ORDER BY al.created_at DESC LIMIT 8")->fetchAll();
require_once __DIR__ . '/../includes/header.php';
?>
<div class="row">
  <div class="col-md-4"><div class="card p-3"><h6>Employees</h6><h2><?= $totUsers ?></h2></div></div>
  <div class="col-md-4"><div class="card p-3"><h6>Total Logs</h6><h2><?= $totLogs ?></h2></div></div>
  <div class="col-md-4"><div class="card p-3"><h6>Quick Actions</h6><a href="/admin/view_logs.php" class="btn btn-sm btn-outline-primary">View Logs</a> <a href="/admin/users.php" class="btn btn-sm btn-outline-secondary">Manage Users</a></div></div>
</div>
<div class="mt-4">
  <h5>Recent Logs</h5>
  <table class="table table-striped">
    <thead><tr><th>Employee</th><th>Title</th><th>Start</th><th>Status</th></tr></thead>
    <tbody>
    <?php foreach($recent as $r): ?>
      <tr>
        <td><?=htmlspecialchars($r['name'])?></td>
        <td><?=htmlspecialchars($r['title'])?></td>
        <td><?=date('Y-m-d H:i', strtotime($r['start_time']))?></td>
        <td><?=htmlspecialchars($r['status'])?></td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table>
</div>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>
