<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../helpers.php';
requireAdmin();
$users = $pdo->query("SELECT id,name FROM users ORDER BY name")->fetchAll();
$where=[]; $params=[];
if (!empty($_GET['user_id'])) { $where[]='al.user_id=?'; $params[]=(int)$_GET['user_id']; }
if (!empty($_GET['status'])) { $where[]='al.status=?'; $params[]=$_GET['status']; }
if (!empty($_GET['from'])) { $where[]='al.start_time>=?'; $params[]=$_GET['from'].' 00:00:00'; }
if (!empty($_GET['to'])) { $where[]='al.start_time<=?'; $params[]=$_GET['to'].' 23:59:59'; }
$sql = 'SELECT al.*, u.name FROM activity_logs al JOIN users u ON u.id=al.user_id';
if ($where) $sql .= ' WHERE '.implode(' AND ', $where);
$sql .= ' ORDER BY al.start_time DESC';
if (!empty($_GET['export'])) {
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $rows = $stmt->fetchAll();
    $csvRows = array_map(function($r){ return [
        'Employee'=>$r['name'],'Title'=>$r['title'],'Description'=>$r['description'],
        'Start'=>$r['start_time'],'End'=>$r['end_time'],'Status'=>$r['status'],'Created At'=>$r['created_at']
    ]; }, $rows);
    exportCSV($csvRows,'activity_logs_export.csv');
}
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$logs = $stmt->fetchAll();
require_once __DIR__ . '/../includes/header.php';
?>
<h4>All Logs</h4>
<form class="row g-2 mb-3">
  <div class="col-md-3"><select name="user_id" class="form-select"><option value="">All employees</option><?php foreach($users as $u): ?><option value="<?=$u['id']?>" <?=(($_GET['user_id'] ?? '')==$u['id'])?'selected':''?>><?=htmlspecialchars($u['name'])?></option><?php endforeach; ?></select></div>
  <div class="col-md-2"><select name="status" class="form-select"><option value="">Any status</option><option>In Progress</option><option>Completed</option></select></div>
  <div class="col-md-2"><input type="date" name="from" class="form-control" value="<?=htmlspecialchars($_GET['from'] ?? '')?>"></div>
  <div class="col-md-2"><input type="date" name="to" class="form-control" value="<?=htmlspecialchars($_GET['to'] ?? '')?>"></div>
  <div class="col-md-3 d-flex gap-2"><button class="btn btn-primary">Filter</button><a class="btn btn-outline-secondary" href="?<?=http_build_query(array_merge($_GET,['export'=>1]))?>">Export CSV</a></div>
</form>
<table class="table table-striped">
  <thead><tr><th>Employee</th><th>Title</th><th>Start</th><th>End</th><th>Status</th><th>Created</th></tr></thead>
  <tbody>
    <?php foreach($logs as $l): ?>
      <tr>
        <td><?=htmlspecialchars($l['name'])?></td>
        <td><?=htmlspecialchars($l['title'])?></td>
        <td><?=htmlspecialchars($l['start_time'])?></td>
        <td><?=htmlspecialchars($l['end_time'])?></td>
        <td><?=htmlspecialchars($l['status'])?></td>
        <td><?=htmlspecialchars($l['created_at'])?></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>
