// theme toggle
document.addEventListener('DOMContentLoaded', function(){
    const t = document.getElementById('themeToggle');
    if(t){
        t.addEventListener('click', function(e){
            e.preventDefault();
            document.body.classList.toggle('dark-mode');
            document.body.classList.toggle('light-mode');
        });
    }
    // quick add AJAX
    const quick = document.getElementById('quickAdd');
    if(quick){
        quick.addEventListener('submit', async function(e){
            e.preventDefault();
            const fd = new FormData(quick);
            const btn = document.getElementById('quickAddBtn');
            btn.disabled = true;
            const res = await fetch('/ajax/create_log.php', { method:'POST', body: fd });
            const json = await res.json();
            btn.disabled = false;
            if(json.success){
                // show bootstrap toast or reload
                alert('Quick log added');
                window.location.reload();
            } else {
                alert(json.error || 'Error');
            }
        });
    }
});
