<?php
// Simple registration page to create users (use for creating initial admin)
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../helpers.php';
$errors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $role = $_POST['role'] ?? 'employee';
    if (!$name || !$email || !$password) $errors[] = 'All fields required.';
    if (empty($errors)) {
        $hash = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $pdo->prepare('INSERT INTO users (name, email, password, role) VALUES (?, ?, ?, ?)');
        try {
            $stmt->execute([$name, $email, $hash, $role]);
            header('Location: /auth/login.php');
            exit;
        } catch (Exception $e) {
            $errors[] = 'Email may already be registered.';
        }
    }
}
?>
<!doctype html>
<html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<title>Register - Activity Log</title>
</head><body class="bg-light">
<div class="container py-5">
<div class="row justify-content-center">
  <div class="col-md-6">
    <div class="card">
      <div class="card-body">
        <h4>Create user</h4>
        <?php if($errors): ?><div class="alert alert-danger"><?=implode('<br>',$errors)?></div><?php endif; ?>
        <form method="post">
          <div class="mb-2"><label class="form-label">Name</label><input class="form-control" name="name" required></div>
          <div class="mb-2"><label class="form-label">Email</label><input class="form-control" type="email" name="email" required></div>
          <div class="mb-2"><label class="form-label">Password</label><input class="form-control" type="password" name="password" required></div>
          <div class="mb-2">
            <label class="form-label">Role</label>
            <select name="role" class="form-select">
              <option value="employee">Employee</option>
              <option value="manager">Manager</option>
              <option value="admin">Admin</option>
            </select>
          </div>
          <button class="btn btn-success">Create</button>
        </form>
      </div>
    </div>
  </div>
</div>
</div>
</body></html>
