<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../helpers.php';
requireLogin();
$errors=[];
if ($_SERVER['REQUEST_METHOD']==='POST') {
    $title = trim($_POST['title']);
    $description = trim($_POST['description']);
    $start_time = $_POST['start_time'];
    $end_time = $_POST['end_time']?:null;
    $status = $_POST['status']??'In Progress';
    if (!$title || !$start_time) $errors[]='Title and start time required.';
    if (!$errors) {
        $stmt = $pdo->prepare('INSERT INTO activity_logs (user_id,title,description,start_time,end_time,status) VALUES (?,?,?,?,?,?)');
        $stmt->execute([$_SESSION['user']['id'],$title,$description,$start_time,$end_time,$status]);
        header('Location: /employee/my_logs.php?msg=created');
        exit;
    }
}
require_once __DIR__ . '/../includes/header.php';
?>
<div class="card"><div class="card-body">
<h5>Add Activity</h5>
<?php if($errors): ?><div class="alert alert-danger"><?=implode('<br>',$errors)?></div><?php endif; ?>
<form method="post">
  <div class="mb-2"><label class="form-label">Title</label><input class="form-control" name="title" required></div>
  <div class="mb-2"><label class="form-label">Description</label><textarea class="form-control" name="description"></textarea></div>
  <div class="mb-2"><label class="form-label">Start time</label><input class="form-control" type="datetime-local" name="start_time" required></div>
  <div class="mb-2"><label class="form-label">End time</label><input class="form-control" type="datetime-local" name="end_time"></div>
  <div class="mb-3"><label class="form-label">Status</label><select class="form-select" name="status"><option>In Progress</option><option>Completed</option></select></div>
  <button class="btn btn-primary">Save</button>
</form>
<hr>
<h6>Or quick add (AJAX)</h6>
<form id="quickAdd">
  <div class="mb-2"><input class="form-control" name="title" placeholder="Quick title" required></div>
  <button class="btn btn-outline-success" id="quickAddBtn">Quick Add</button>
</form>
</div></div>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>
