<?php
require_once __DIR__ . '/../helpers.php';
$user = $_SESSION['user'] ?? null;
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title>Activity Log</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"/>
  <link href="/assets/css/styles.css" rel="stylesheet"/>
</head>
<body class="light-mode">
<nav class="navbar navbar-expand-md navbar-dark bg-primary">
  <div class="container">
    <a class="navbar-brand" href="/">Rex ActivityLog</a>
    <button class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#nav"><span class="navbar-toggler-icon"></span></button>
    <div id="nav" class="collapse navbar-collapse">
      <ul class="navbar-nav ms-auto">
        <?php if($user): ?>
          <?php if($user['role'] === 'admin'): ?>
            <li class="nav-item"><a class="nav-link" href="/admin/index.php">Admin</a></li>
          <?php endif; ?>
          <li class="nav-item"><a class="nav-link" href="/employee/dashboard.php">Dashboard</a></li>
          <li class="nav-item"><a class="nav-link" href="/auth/logout.php">Logout</a></li>
          <li class="nav-item"><a class="nav-link" href="#" id="themeToggle">Toggle Theme</a></li>
        <?php else: ?>
          <li class="nav-item"><a class="nav-link" href="/auth/login.php">Login</a></li>
        <?php endif; ?>
      </ul>
    </div>
  </div>
</nav>
<main class="container my-4">
